/*****************************************************************************
 *   qei.c:  QEI module file for NXP LPC29xx Family Microprocessors
 *
 *   Copyright(C) 2009, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2009.12.17  ver 1.00    Preliminary version, first Release
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *****************************************************************************/

#include "LPC29xx.h"                        	// LPC29xx definitions 
#include "type.h"
#include "irq.h"
#include "qei.h"

volatile BYTE qei_index = FALSE;	  			// Flag if index pulse has occured

/*****************************************************************************
** Function name:		INIT_QEI
**
** Descriptions:		Initialize QEI
**
*****************************************************************************/
void INIT_QEI(void)
{
    SFSP3_13    = (3<<2) | (3<<0);	           // Digital input with pull-up, 3rd function QEI0 IDX
    SFSP0_0     = (3<<2) | (1<<0);             // Digital input with pull-up, 1st function QEI0 PHB
    SFSP0_1     = (3<<2) | (1<<0);             // Digital input with pull-up, 1st function QEI0 PHA

    QEILOAD = 3600000;
	QEICON  = 0x0F;             				// reset index counter, velocity, reset on index
	QEICONF = QEI_CAPMODE | QEI_DIRINV;   		// QE inputs, count A/B edges, no inversion
    QEIMAXPOS = QEI_CNTS;         				// set QEI max pos
	FILTER  = 20;								// set number of samples for valid value
    QEIIEC  = 0x0001FFF;        				// disable all QEI interrupts
    QEICLR  = 0x0001FFF;        				// clear all QEI pending interrupts   
	QEIIES  = (1<<0);							// Enable index interrupt
    install_irq( 52, (void *)QEIHandler, HIGHEST_PRIORITY-1 );
    EnableIntReq_IRQ( 52, ACTIVE_HIGH, HIGHEST_PRIORITY-1 );
	return;     
}

/*****************************************************************************
** Function name:		QEIHandler
**
** Descriptions:		QEI interrupt handler
**
*****************************************************************************/
void QEIHandler(void)
{
    DWORD regVal;
	qei_index = TRUE;							// Index pulse occured
    regVal = QEIINTSTAT;
   	if( regVal & (1<<0))QEICON  = (1<<1);		// Indicates that an index pulse was detected.
	QEICLR |= regVal;                       	//clear QEI interrupt sources
    return;
}


												 

